% ex7_52enkf.m
% Estimation of heat equation 
% by Ensemble Kalman filter 
% section 7.5.2
clear

dt=0.1;
dt2=sqrt(dt);
T=100;
N=T/dt;
NN=0:N;
drho=1;
alpha=2.5;
f1=1/1000;
f2=1/1000;
lam=alpha*dt/drho^2;
xb0=30;
xbL=30;
x00=30;
n=99;  % j=1:n
j1=33;
j2=67;
p=9;
x0=zeros(n,1);
for j=1:n
    x0(j,1)=x00;
end    
dd=zeros(n,1);
dd(1,1)=lam*xb0;
dd(n,1)=lam*xbL;
b1=5; b2=5;
u=zeros(2,N+1);
for k=1:N+1
u(1,k)=b1*sin(2*pi*f1*(k-1))+b1;
u(2,k)=b2*sin(2*pi*f2*(k-1))+b2;
end
B1=zeros(n,1);
B2=zeros(n,1);
B1(j1,1)=dt;
B2(j2,1)=dt;
for i=1:n-1
    F(i,i)=1-2*lam;
    F(i,i+1)= lam;
    F(i+1,i)=lam;
end
F(n,n)=1-2*lam;
H=zeros(p,n);
y=zeros(p,N+1);
for i=1:p
    H(i,10*i)=1;
end    

Q=0.001*eye(n,n);
R=0.1*eye(p,p);
jj=40;
% Number of particles M
M=100
% M=200
% M=500
MM=30;   % Number of Monte Calro runs MM
tic
for mc=1:MM
mc
% Data generation 
w=sqrt(Q)*randn(n,N+1);   % system noise
v=sqrt(R)*randn(p,N+1);   % observation noise
x=zeros(n,N+1);
x(:,1)=x0;
for k=1:N
x(:,k+1)=F*x(:,k) + dd + B1*u(1,k)+B2*u(2,k)+dt2*w(:,k);
y(:,k)= H*x(:,k) + v(:,k);
end
y(:,N+1)=H*x(:,N+1)+v(:,N+1);
% EnKalman filter
% initial values
Ex=zeros(n,M);
Ey=zeros(p,M);
xt0=sqrt(1)*randn(n,M);     % initial ensemble
xep=x00*ones(n,M);
xep=xep+xt0;
yep=zeros(p,M);   % ensemble for output prediction
xef=zeros(n,M);   % ensamble for filtered estimate
Re=R;             % covariance of observation noise
Qe=Q;
% Estimation 
for k=1:N+1
% observation update
% Input: (xep) --> Output (xef)
ve=sqrt(Re)*randn(p,M);  % observation noise 
for i=1:M
    yep(:,i)=H*xep(:,i)+ve(:,i);
end
xx=mean(xep,2);
yy=mean(yep,2);
for i=1:M
Ex(:,i)=xep(:,i)-xx; % state prediction error
Ey(:,i)=yep(:,i)-yy; % ensemble for prediction error
end
Pxy=(Ex*Ey')/(M-1);
Pyy=(Ey*Ey')/(M-1);
% EnKF gain & filtering
Kt=Pxy*inv(Pyy);   % EnKF gain ( dimension n x p )
for i=1:M
    temp=y(:,k)-yep(:,i);         % prediction output error
    xef(:,i)=xep(:,i)+Kt*temp;    % update of ensemble
end
xmean=mean(xef,2);
xhat(:,k)=xmean;      % filtered estimate
Khat(:,:,k)=Kt;       %
% time update Input: (xef) --> Output (xep)
we=sqrt(Qe)*randn(n,M);  % system noise for estimation
for i=1:M
xep2=F*xef(:,i)+dd+B1*u(1,k)+B2*u(2,k)+dt2*we(:,i);
xep(:,i)=xep2;
end
end  % of k

T2=toc
for k=1:N+1
Et(mc,k)=(xhat(jj,k)-x(jj,k))^2; 
end
end % end of mc
Ett=mean(Et,1);


J=NN;
Ymax=1e-1;
Ymin=1e-4;
figure(1)
semilogy(J,Ett,'b-','LineWidth',1.5)    % for M=100
%semilogy(J,Ett,'g-','LineWidth',1.5)   % for M=200
%semilogy(J,Ett,'r-','LineWidth',1.5)   % for M=500
title('Fig. 7.7: Sample value E_k by EnKF')
xlabel('Number of steps k')
axis([0 1000 Ymin Ymax])
hold on
grid
